///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK RestoreWithMoveDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND NewDBName_hWnd = NULL;
    static HWND NewDBLoc_hWnd  = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        RestoreWithMoveDialog_hWnd = xHandle;

        SendMessage(RestoreWithMoveDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Select Database");
        SendMessage(RestoreWithMoveDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        NewDBName_hWnd = GetDlgItem(RestoreWithMoveDialog_hWnd, 1000);
        NewDBLoc_hWnd  = GetDlgItem(RestoreWithMoveDialog_hWnd, 1001);

        //-------------------------------------------------------------------------

        if(RWMD.Complete == TRUE)
        {
            Set_Text(NewDBName_hWnd, RWMD.NewDBName);
            Set_Text(NewDBLoc_hWnd, RWMD.NewDBLoc);
        }

        CenterWindow(RestoreWithMoveDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            char xNewDBName[256];
            char xNewDBLoc[256];

            if(Get_TextEx(NewDBName_hWnd, xNewDBName, 256) == 0)
            {
                MessageBox(RestoreWithMoveDialog_hWnd, "You must specifiy a new database name.", TitleCaption, 0);
                return 0;
            }

            if(Get_TextEx(NewDBLoc_hWnd, xNewDBLoc, 256) == 0)
            {
                MessageBox(RestoreWithMoveDialog_hWnd, "You must select a new database location.", TitleCaption, 0);
                return 0;
            }


            strcpy(RWMD.NewDBName, xNewDBName);
            strcpy(RWMD.NewDBLoc, xNewDBLoc);

            Set_Text(MRD.DataBase_hWnd, xNewDBName);

            RWMD.Complete = TRUE;

            EndDialog(RestoreWithMoveDialog_hWnd,0);
            DestroyWindow(RestoreWithMoveDialog_hWnd);
            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            EndDialog(RestoreWithMoveDialog_hWnd,0);
            DestroyWindow(RestoreWithMoveDialog_hWnd);
            return 0;
        }

        if(wParam == 102) //- Browse (Dialog Command)
        {
            char Return[256];
            if(BrowseDirectory(RestoreWithMoveDialog_hWnd, TitleCaption, 0, Return))
            {
                Set_Text(NewDBLoc_hWnd, Return);
            }

            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(RestoreWithMoveDialog_hWnd,0);
        DestroyWindow(RestoreWithMoveDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

